/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.WildfireShieldDebrisEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5819;

public final class WildfireBarrageAttackTask
extends class_4097<WildfireEntity> {
    private int shieldDebrisFired;
    private int shieldDebrisCooldown;
    private boolean canDoMeeleAttack;
    private class_1309 attackTarget;
    private int attackTargetIsNotVisibleTicks;
    private static final int BARRAGE_ATTACK_DURATION = 180;
    private static final int MAX_FIREBALLS_TO_BE_FIRED = 30;

    public WildfireBarrageAttackTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), (Object)class_4141.field_18457), 180);
    }

    protected boolean shouldRun(class_3218 world, WildfireEntity wildfire) {
        class_1309 attackTarget = wildfire.method_18868().method_18904(class_4140.field_22355).orElse(null);
        if (attackTarget == null || !attackTarget.method_5805() || attackTarget instanceof class_1657 && (attackTarget.method_7325() || ((class_1657)attackTarget).method_7337())) {
            return false;
        }
        this.attackTarget = attackTarget;
        return true;
    }

    protected void run(class_3218 world, WildfireEntity wildfire, long time) {
        wildfire.method_18868().method_18875(class_4140.field_18445);
        wildfire.method_5942().method_6340();
        class_4215.method_19554((class_1309)wildfire, (class_1309)this.attackTarget);
        wildfire.method_5988().method_35111((class_1297)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        this.shieldDebrisFired = 0;
        this.attackTargetIsNotVisibleTicks = 0;
        this.canDoMeeleAttack = true;
    }

    protected boolean shouldKeepRunning(class_3218 world, WildfireEntity wildfire, long time) {
        if (!this.attackTarget.method_5805()) {
            this.attackTarget = wildfire.method_18868().method_18904(class_4140.field_22354).orElse(null);
        }
        if (this.attackTarget == null || !this.attackTarget.method_5805() || !this.attackTarget.method_5805() || this.attackTarget instanceof class_1657 && (this.attackTarget.method_7325() || ((class_1657)this.attackTarget).method_7337()) || this.shieldDebrisFired > 30) {
            return false;
        }
        class_1657 nearestVisibleTargetablePlayer = wildfire.method_18868().method_18904(class_4140.field_22354).orElse(null);
        return nearestVisibleTargetablePlayer == null || !nearestVisibleTargetablePlayer.method_5805() || !(wildfire.method_5739((class_1297)nearestVisibleTargetablePlayer) <= 6.0f) || !wildfire.method_18868().method_18876(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), class_4141.field_18457);
    }

    protected void keepRunning(class_3218 world, WildfireEntity wildfire, long time) {
        wildfire.method_5988().method_35111((class_1297)this.attackTarget);
        boolean isAttackTargetVisible = wildfire.method_5985().method_6369((class_1297)this.attackTarget);
        this.attackTargetIsNotVisibleTicks = isAttackTargetVisible ? 0 : ++this.attackTargetIsNotVisibleTicks;
        double targetX = this.attackTarget.method_23317() - wildfire.method_23317();
        double targetY = this.attackTarget.method_23323(0.5) - wildfire.method_23323(0.5);
        double targetZ = this.attackTarget.method_23321() - wildfire.method_23321();
        if (this.shieldDebrisCooldown > 0) {
            --this.shieldDebrisCooldown;
            return;
        }
        if (this.canDoMeeleAttack && wildfire.method_5739((class_1297)this.attackTarget) < 3.0f) {
            wildfire.method_6121((class_1297)this.attackTarget);
            this.canDoMeeleAttack = false;
        } else {
            this.canDoMeeleAttack = true;
        }
        if (this.attackTargetIsNotVisibleTicks > 5) {
            wildfire.method_5962().method_6239(this.attackTarget.method_23317(), this.attackTarget.method_23318(), this.attackTarget.method_23321(), (double)wildfire.method_6029());
        }
        double distanceToAttackTarget = wildfire.method_5858((class_1297)this.attackTarget);
        double h = Math.sqrt(Math.sqrt(distanceToAttackTarget)) * 0.5;
        if (!wildfire.method_5701()) {
            wildfire.playShootSound();
            wildfire.method_37908().method_8444(null, 1018, wildfire.method_24515(), 0);
        }
        class_5819 random = wildfire.method_59922();
        for (int i = 0; i < 8; ++i) {
            WildfireShieldDebrisEntity shieldDebris = new WildfireShieldDebrisEntity((class_1937)world, (class_1309)wildfire, new class_243(random.method_43385(targetX, 2.297 * h), targetY, random.method_43385(targetZ, 2.297 * h)));
            shieldDebris.method_5814(shieldDebris.method_23317(), wildfire.method_23323(0.5) + 0.5, shieldDebris.method_23321());
            wildfire.method_37908().method_8649((class_1297)shieldDebris);
            ++this.shieldDebrisFired;
        }
        this.shieldDebrisCooldown = 10;
    }

    protected void finishRunning(class_3218 world, WildfireEntity wildfire, long time) {
        WildfireBrain.setBarrageAttackCooldown(wildfire);
    }
}

